<?php

namespace Anibalealvarezs\AmazonApi\Services\SellingPartner\Enums\ReportTypes\FulfillmentByAmazon;

use Anibalealvarezs\AmazonApi\Services\SellingPartner\Interfaces\ReportOptions;

/**
 * @see https://developer-docs.amazon.com/sp-api/docs/report-type-values-fba
 */
enum Sales: string implements ReportOptions
{
    case GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL = 'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL';
    case GET_AMAZON_FULFILLED_SHIPMENTS_DATA_INVOICING = 'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_INVOICING';
    case GET_AMAZON_FULFILLED_SHIPMENTS_DATA_TAX = 'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_TAX';
    case GET_FLAT_FILE_ALL_ORDERS_DATA_BY_LAST_UPDATE_GENERAL = 'GET_FLAT_FILE_ALL_ORDERS_DATA_BY_LAST_UPDATE_GENERAL';
    case GET_FLAT_FILE_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL = 'GET_FLAT_FILE_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL';
    case GET_XML_ALL_ORDERS_DATA_BY_LAST_UPDATE_GENERAL = 'GET_XML_ALL_ORDERS_DATA_BY_LAST_UPDATE_GENERAL';
    case GET_XML_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL = 'GET_XML_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL';
    case GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA = 'GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA';
    case GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_PROMOTION_DATA = 'GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_PROMOTION_DATA';
    case GET_FBA_FULFILLMENT_CUSTOMER_TAXES_DATA = 'GET_FBA_FULFILLMENT_CUSTOMER_TAXES_DATA';
    case GET_REMOTE_FULFILLMENT_ELIGIBILITY = 'GET_REMOTE_FULFILLMENT_ELIGIBILITY';

    /**
     * @return array
     */
    public static function getValues(): array
    {
        return [
            self::GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL,
            self::GET_AMAZON_FULFILLED_SHIPMENTS_DATA_INVOICING,
            self::GET_AMAZON_FULFILLED_SHIPMENTS_DATA_TAX,
            self::GET_FLAT_FILE_ALL_ORDERS_DATA_BY_LAST_UPDATE_GENERAL,
            self::GET_FLAT_FILE_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL,
            self::GET_XML_ALL_ORDERS_DATA_BY_LAST_UPDATE_GENERAL,
            self::GET_XML_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL,
            self::GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA,
            self::GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_PROMOTION_DATA,
            self::GET_FBA_FULFILLMENT_CUSTOMER_TAXES_DATA,
            self::GET_REMOTE_FULFILLMENT_ELIGIBILITY,
        ];
    }

    /**
     * @return array
     */
    public function getReportOptions(): array
    {
        return [];
    }
}
