<?php

namespace Google\Services\Sheets\Classes\Objects\Charts;

use Anibalealvarezs\GoogleApi\Google\Helpers\Helpers;
use Anibalealvarezs\GoogleApi\Google\Interfaces\Jsonable;

/**
 * @see https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/other#datasourcecolumnreference
 */
class DataSourceColumnReference implements Jsonable
{
    public string $name;
    
    public function __construct(
        string $name
    ) {
        $this->name = $name;
    }

    public function toJson(): string
    {
        return json_encode(Helpers::getJsonableArray($this));
    }
}
